# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - arnica

    This macro is used to call the arnica parser,
    it is just a thin wrapper around it.

    Based on Gallery2/gallery2image, (c) 2005-2008 by MoinMoin:ReimarBauer

    @copyright: 2008 by MoinMoin:ReimarBauer
    @license: GNU GPL, see COPYING for details.
"""
from MoinMoin import wikiutil

class arnica:
    def __init__(self, macro, args):
        self.macro = macro
        self.formatter = macro.formatter
        self.args = args

    def renderInPage(self):
        arnica_parser = wikiutil.importPlugin(self.macro.cfg, 'parser', 'text_x_arnica', 'Parser')
        if arnica_parser is None:
            return self.formatter.text("Please install the arnica parser!")

        ap = arnica_parser("", self.macro.request, format_args=self.args)
        if ap.init_settings:
            return ap.render(self.formatter)

def execute(macro, args):
    result = arnica(macro, args).renderInPage()
    if result:
        return '<div class="arnica"> %s </div>' % result
    else:
        return u''
