# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - refresh cache of a page

    @copyright: 2000-2004 Juergen Hermann <jh@web.de>,
                2006 MoinMoin:ThomasWaldmann
                2008 MoinMoin:ReimarBauer
    @license: GNU GPL, see COPYING for details.
"""
import os
from MoinMoin import config, wikiutil
from MoinMoin.action import AttachFile, cache
from MoinMoin.Page import Page

def execute(pagename, request):
    """ Handle refresh action """
    # Without arguments, refresh action will refresh the page text_html cache.
    arena = request.form.get('arena', ['Page.py'])[0]
    if arena == 'Page.py':
        arena = Page(request, pagename)
    key = request.form.get('key', ['text_html'])[0]

    # Remove cache entry (if exists)
    from MoinMoin import caching
    caching.CacheEntry(request, arena, key, scope='item').remove()
    caching.CacheEntry(request, arena, "pagelinks", scope='item').remove()

    # Remove cache key files of current page
    attachment_files = AttachFile._get_files(request, pagename)
    path = caching.CacheEntry(request, cache.cache_arena, "",
                              cache.cache_scope, do_locking=False)._filename()

    key_files = [fn.decode(config.charset) for fn in os.listdir(path)
                 if fn.endswith('data') or fn.endswith('meta')]

    for attfile in attachment_files:
        key = cache.key(request, itemname=pagename, attachname=attfile)
        for file_name in key_files:
            file, ext = os.path.splitext(file_name)
            if file.endswith(key):
                cache.remove(request, file)

    request.page.send_page()
